<?php
	
	class Extension_BiLinkField extends Extension {
	/*-------------------------------------------------------------------------
		Definition:
	-------------------------------------------------------------------------*/
		
		public function about() {
			return array(
				'name'			=> 'Field: Bi Link',
				'version'		=> '1.1.1',
				'release-date'	=> '2011-04-11',
				'author'		=> array(
					'name'			=> 'Rowan Lewis',
					'website'		=> 'http://nbsp.io/',
					'email'			=> 'me@nbsp.io'
				),
				'description'	=> 'A bi-directional linking system for Symphony.'
			);
		}
		
		public function install() {
			Symphony::Database()->query("
				CREATE TABLE IF NOT EXISTS `tbl_fields_bilink` (
					`id` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
					`field_id` INT(11) UNSIGNED NOT NULL,
					`linked_section_id` INT(11) UNSIGNED DEFAULT NULL,
					`linked_field_id` INT(11) UNSIGNED DEFAULT NULL,
					`allow_editing` ENUM('yes','no') DEFAULT 'no',
					`allow_multiple` ENUM('yes','no') DEFAULT 'no',
					`column_mode` ENUM('count','first-item','last-item','small-list','large-list') DEFAULT NULL,
					PRIMARY KEY (`id`),
					KEY `field_id` (`field_id`),
					KEY `linked_section_id` (`linked_section_id`),
					KEY `linked_field_id` (`linked_field_id`)
				) ENGINE=MyISAM DEFAULT CHARSET=utf8;
			");
			
			return true;
		}
		
		public function uninstall() {
			$this->_Parent->Database->query("DROP TABLE `tbl_fields_bilink`");
			
			return true;
		}
		
		public function update($previousVersion=false) {
			if (version_compare($previousVersion, '1.1.0', '<')) {
				Symphony::Database()->query("
					ALTER TABLE `tbl_fields_bilink`
					ADD COLUMN `allow_editing` ENUM('yes','no') DEFAULT 'no';
				");
			}
			
			return true;
		}
		
	/*-------------------------------------------------------------------------
		Utilites:
	-------------------------------------------------------------------------*/
		
		protected $addedHeaders = false;
		
		public function addHeaders($page) {
			if (!$this->addedHeaders) {
				$page->addStylesheetToHead(URL . '/extensions/bilinkfield/assets/publish.css', 'screen', 123269781);
				$page->addScriptToHead(URL . '/extensions/bilinkfield/assets/publish.js', 123269781);
				
				$this->addedHeaders = true;
			}
		}
	}
		
?>