<?php

    require_once(TOOLKIT . '/class.datasource.php');

    Class datasourceBreadcrumbs extends Datasource {

        /**
         *
         * name of the root XML element that wraps the data
         * @var string
         */
        public $dsParamROOTELEMENT = 'breadcrumbs';

        /**
         *
         * Credits method
         */
        public function about(){
            return array(
                     'name' => 'Breadcrumbs',
                     'version' => '1.0',
                     'release-date' => '2012-06-05',
                     'author' => array('name' => 'Jordy Boezaard',
                                       'website' => 'http://www.bitterzoetmedia.nl',
                                       'email' => 'jordy@bitterzoetmedia.nl')
            );
        }

        /**
         *
         * Class constructor
         * @param object $parent
         * @param array $env
         * @param boolean $process_params
         */
        public function __construct(&$parent, Array $env = null, $process_params=true){
            parent::__construct($parent, $env, $process_params);

        }

        /**
         *
         * Method called by Symphony in order to build the
         * @param $param_pool
         * @return XMLElement
         */
        public function grab(&$param_pool)
        {
            // prepare output
            $result = new XMLElement($this->dsParamROOTELEMENT);
            
            // home?
            if (strlen($this->_env['param']['current-path']) == 1
                || $this->_env['param']['current-path'] == '/home/')
            {
                return $result;
            }
            
            // Get the path
            $sUrlPath = $this->_env['param']['current-path'];
            
            // Remove leading and trailing slash
            $sCurrentPath = substr($sUrlPath, 1, strlen($sUrlPath) - 2);
            
            // Split on /
            $aUrlParts = explode('/', $sCurrentPath);
            
            
            // Walk the stack
            do
            {
                $sLastElement = $aUrlParts[count($aUrlParts) - 1];
                
                $sPath = (count($aUrlParts) > 1 || (strtolower($sLastElement) != 'informatie' && strtolower($sLastElement) != 'pagina')) ? '/' . implode('/', $aUrlParts) . '/' : '';
                
                $result->appendChild(
                    new XMLElement(
                        'crumb',
                        $this->sanitizeUrlPart($sLastElement), // value
                        array(
                            'path' => $sPath
                        ) // attributes
                    )
                );
                
                // Pop last element
                array_pop($aUrlParts);
            }
            while (count($aUrlParts) > 0);
            
            // return xml result set
            return $result;
        }

        private function sanitizeUrlPart($sUrlPart)
        {
            $aSearch = array(
                '-'
            );
            
            $aReplace = array(
                ' '
            );
            
            return ucfirst(str_replace($aSearch, $aReplace, $sUrlPart));
        }
        
    }

