<?php

	$about = array(
		'name' => 'Nederlands',
		'author' => array(
			'name' => 'Carsten de Vries',
			'email' => 'carsten@vrieswerk.nl',
			'website' => 'http://www.vrieswerk.nl',
		),
		'release-date' => '2009-11-09',
	);
	
	
	/*
	 * CORE: Symphony
	 * Localisation strings
	 */

	$dictionary = array(
	
		// Missing translations
		'A database error occurred while attempting to reorder.' => 
		'Er is een databasefout opgetreden tijdens een poging om te sorteren.',

		'%1$s &ndash; %2$s' => 
		'%1$s &ndash; %2$s',

		'Symphony' => 
		'Symphony',

		'Components' =>
		'Onderdelen',

		'Events' => 
		'Gebeurtenissen',

		'Create New' => 
		'Maak nieuw',

		'Create a new event' => 
		'Maak een nieuwe gebeurtenis',

		'Data Sources' => 
		'Gegevensbronnen',

		'Create a new data source' => 
		'Maak een nieuwe gegevensbron',

		'Utilities' => 
		'Bouwstenen',

		'Create a new utility' => 
		'Maak een nieuwe bouwsteen',

		'An error occurred while processing this form. <a href="#error">See below for details.</a>' => 
		'Er is een fout opgetreden bij het verwerken van dit formulier. <a href="#error">Zie hieronder voor meer informatie.</a> ',

		'Data source updated at %1$s. <a href="%2$s">Create another?</a> <a href="%2$s">View all Data sources</a>' => 
		'Gegevensbron %1$s bijgewerkt. <a href="%2$s">Maak er nog één.</a> <a href="%2$s">Bekijk alle gegevensbronnen</a>',

		'Data source created at %1$s. <a href="%2$s">Create another?</a> <a href="%3$s">View all Data source</a>' => 
		'Gegevensbron %1$s gemaakt. <a href="%2$s">Maak er nog één.</a> <a href="%3$s">Bekijk alle gegevensbronnen</a>',

		'%1$s &ndash; %2$s &ndash; %3$s' => 
		'%1$s &ndash; %2$s &ndash; %3$s',

		'Untitled' => 
		'Naamloos',

		'Essentials' => 
		'Essentialia',

		'Name' => 
		'Naam',

		'Source' => 
		'Bron',

		'System' => 
		'Systeem',

		'authors' => 
		'auteurs',

		'Authors' => 
		'Auteurs',

		'navigation' => 
		'navigatie',

		'Navigation' => 
		'Navigatie',

		'Custom XML' => 
		'Gebruikersgedefinieerde XML',

		'dynamic_xml' => 
		'dynamische_xml',

		'Dynamic XML' => 
		'Dynamische XML',

		'static_xml' => 
		'statische_xml',

		'Static XML' => 
		'Statische XML',

		'Sections' => 
		'Secties',

		'sections' => 
		'secties',

		'Filter Results' => 
		'Filter resultaten',

		'Use <code>{$param}</code> syntax to filter by page parameters.' => 
		'Gebruik <code>{$param}</code> syntaxis om te filteren op paginaparameter.',

		'Filter %s by' => 
		'Filter %s op',

		'System ID' => 
		'Systeem-ID',

		'Value' => 
		'Waarde',

		'Filter Authors by' => 
		'Filter auteurs op',

		'ID' => 
		'ID',

		'Username' => 
		'Gebruikersnaam',

		'First Name' => 
		'Voornaam',

		'Last Name' => 
		'Achternaam',

		'Email' => 
		'E-mail',

		'User Type' => 
		'Gebruikerstype',

		'Filter Navigation by' => 
		'Filter navigatie op',

		'Parent Page' => 
		'Bovengeschikte pagina',

		'Page Type' => 
		'Paginatype',

		'Sorting and Limiting' => 
		'Sorteren en limiteren',

		'Use <code>{$param}</code> syntax to limit by page parameters.' => 
		'Gebruik <code>{$parameter}</code> syntaxis om te limiteren op paginaparameter.',

		'Sort By' => 
		'Sorteer op',

		'Author ID' => 
		'Auteur-ID',

		'Status' => 
		'Status',

		'Page ID' => 
		'Pagina-ID',

		'Handle' => 
		'Identifier',

		'Sort Order' => 
		'Sorteervolgorde',

		'System Date' => 
		'Systeemdatum',

		'ascending' => 
		'oplopend',

		'descending' => 
		'aflopend',

		'random' => 
		'willekeurig',

		'Show a maximum of %s results' => 
		'Toon een maximum van %s resultaten',

		'Show page %s of results' => 
		'Toon pagina %s van resultaten',

		'Required URL Parameter <i>Optional</i>' => 
		'Verplichte URL-parameter <i>Optioneel</i>',

		'An empty result will be returned when this parameter does not have a value. Do not wrap the parameter with curly-braces.' => 
		'Een leeg resultaat zal worden geretourneerd wanneer deze parameter geen waarde heeft. Plaats geen accolades om de parameter.',

		'%s Redirect to 404 page when no results are found' => 
		'%s Doorsturen naar 404-pagina als er geen resultaten worden gevonden',

		'Output Options' => 
		'Uitvoeropties',

		'Parameter Output' => 
		'Uitvoerparameter',

		'Use Field' => 
		'Gebruik veld',

		'None' => 
		'Geen',

		'User type' => 
		'Gebruikerstype',

		'System Author' => 
		'Systeemauteur',

		'The parameter <code id="output-param-name">$ds-%s</code> will be created with this field\'s value for XSLT or other data sources to use.' => 
		'De parameter <code id="output-param-name">$ds-%s</code> zal met de waarde van dit veld worden gemaakt om te gebruiken door XSLT of andere gegevensbronnen.',

		'XML Output' => 
		'XML-uitvoer',

		'Group By' => 
		'Groepeer Op',

		'Author' => 
		'Auteur',

		'Included Elements' => 
		'Bijgevoegde elementen',

		'%s HTML-encode text' => 
		'%s HTML-codeer tekst',

		'URL' => 
		'URL',

		'Use <code>{$param}</code> syntax to specify dynamic portions of the URL.' => 
		'Gebruik <code>{$param}</code> syntaxis om dynamische delen van de URL op te geven.',

		'Namespace Declarations <i>Optional</i>' => 
		'Naamruimtedeclaratie',

		'URI' => 
		'URI',

		'Namespace' => 
		'Naamruimte',

		'Use an XPath expression to select which elements from the source XML to include.' => 
		'Gebruik een XPath-expressie om te selecteren welke elementen uit de XML-bron opgenomen moeten worden.',

		'Body' => 
		'Inhoud',

		'Save Changes' => 
		'Wijzigingen opslaan',

		'Create Data Source' => 
		'Maak gegevensbron',

		'Delete this data source' => 
		'Verwijder deze gegevensbron',

		'Data Source' => 
		'Gegevensbron',

		'Failed to delete <code>%s</code>. Please check permissions.' => 
		'Verwijderen van <code>%s</ code> mislukt. Controleer machtigingen.',

		'This is a required field' => 
		'Dit is een vereist veld',

		'XML is invalid' => 
		'XML is ongeldig',

		'Must be a valid number' => 
		'Moet een geldig getal zijn',

		'Must be greater than zero' => 
		'Moet groter zijn dan nul',

		'A result limit must be set' => 
		'Er moet een resultatenlimiet opgegeven worden',

		'Must be a valid number or parameter' => 
		'Moet een geldig getal of parameter zijn',

		'A page number must be set' => 
		'Er moet een paginanummer opgegeven worden',

		'A Data source with the name <code>%s</code> name already exists' => 
		'Er bestaat al een gegevensbron met de naam <code>%s</code>',

		'Failed to write Data source to <code>%s</code>. Please check permissions.' => 
		'Schrijven van gegevensbron naar <code>%s</code> mislukt. Controleer machtigingen.',

		'Event updated at %1$s. <a href="%2$s">Create another?</a> <a href="%3$s">View all Events</a>' => 
		'Gebeurtenis %1$s bijgewerkt. <a href="%2$s">Maak er nog één.</a> <a href="%3$s">Bekijk alle gebeurtenissen</a>',

		'Event created at %1$s. <a href="%2$s">Create another?</a> <a href="%3$s">View all Events</a>' => 
		'Gebeurtenis %1$s gemaakt. <a href="%2$s">Maak er nog één.</a> <a href="%3$s">Bekijk alle gebeurtenissen</a>',

		'Filter Rules' => 
		'Filterregels',

		'Admin Only' => 
		'Alleen beheerders',

		'Send Email' => 
		'Verstuur e-mail',

		'Allow Multiple' => 
		'Meerdere toestaan',

		'This event will not be processed if any of these rules return true.' => 
		'Deze gebeurtenis zal niet uitgevoerd worden als één van deze regels waar retourneert.',

		'Description' => 
		'Beschrijving',

		'Create Event' => 
		'Maak gebeurtenis',

		'Delete' => 
		'Verwijderen',

		'Delete this event' => 
		'Verwijder deze gebeurtenis',

		'An Event with the name <code>%s</code> name already exists' => 
		'Er bestaat al een gebeurtenis met de naam <code>%s</code>',

		'Success and Failure XML Examples' => 
		'Voorbeelden van correcte en incorrecte XML',

		'When saved successfully, the following XML will be returned:' => 
		'Indien succesvol opgeslagen zal de volgende XML worden geretourneerd:',

		'Entry [created | edited] successfully.' => 
		'Items succesvol [gemaakt | bewerkt].',

		'When an error occurs during saving, due to either missing or invalid fields, the following XML will be returned' => 
		'Als er een fout optreedt tijdens het opslaan als gevolg van ontbrekende of ongeldige velden zal de volgende XML worden geretourneerd',

		' (<b>Notice that it is possible to get mixtures of success and failure messages when using the "Allow Multiple" option</b>)' => 
		' (<b>Let er op dat het mogelijk is om een mix van succes- en foutberichten te krijgen als de optie "meerdere toestaan" gebruikt wordt</b>) ',

		'Entry encountered errors when saving.' => 
		'Fouten opgetreden bij het opslaan van items.',

		'The following is an example of what is returned if any filters fail:' => 
		'Het volgende is een voorbeeld van wat er geretourneerd wordt als filters falen:',

		'Recipient username was invalid' => 
		'Gebruikersnaam van ontvanger was ongeldig',

		'Example Front-end Form Markup' => 
		'Voorbeeld formulier-opmaak in gebruikersscherm',

		'This is an example of the form markup you can use on your frontend:' => 
		'Dit is een voorbeeld van de formulier-opmaak je kan gebruiken in je gebruikersomgeving:',

		'Submit' => 
		'Verstuur',

		'To edit an existing entry, include the entry ID value of the entry in the form. This is best as a hidden field like so:' => 
		'Om bestaande items te bewerken moet de waarde van het item-ID bijgevoegd worden aan het formulier. Dit kan het best met een verborgen veld op deze manier:',

		'To redirect to a different location upon a successful save, include the redirect location in the form. This is best as a hidden field like so, where the value is the URL to redirect to:' => 
		'Om door te sturen naar een andere locatie bij succesvol opslaan moet de doorstuurlocatie bijgevoegd worden aan het formulier. Dit kan het best met een verborgen veld met als waarde de URL om naar door te sturen op deze manier:',

		'Send Email Filter' => 
		'E-mailfilter',

		'The send email filter, upon the event successfully saving the entry, takes input from the form and send an email to the desired recipient. <b>This filter currently does not work with the "Allow Multiple" option.</b> The following are the recognised fields:' => 
		'Als de items succesvol worden opgeslagen door de gebeurtenis stuurt het e-mailfilter de invoer van het formulier naar de gewenste ontvanger. <b>Dit filter werkt op dit moment niet met de optie "meerdere toestaan"</b> De volgende velden worden herkend:',

		'Optional' => 
		'Optioneel',

		'list of comma author usernames.' => 
		'lijst van komma auteurgebruikersnamen.',

		'All of these fields can be set dynamically using the exact field name of another field in the form as shown below in the example form:' => 
		'Deze velden kunnen allemaal dynamisch ingevuld worden door de exacte veldnamen van een ander formulierveld te gebruiken zoals hieronder in het voorbeeld formulier getoond:',

		'Message' => 
		'Bericht',

		'Failed to write Event to <code>%s</code>. Please check permissions.' => 
		'Schrijven van gebeurtenis naar <code>%s</code> mislukt. Controleer machtigingen.',

		'Pages' => 
		'Pagina\'s',

		'Create a new page' => 
		'Maak een nieuwe pagina',

		'Title' => 
		'Titel',

		'Template' => 
		'Sjabloon',

		'<acronym title="Universal Resource Locator">URL</acronym>' => 
		'<acronym title="Universal Resource Locator">URL</acronym>',

		'<acronym title="Universal Resource Locator">URL</acronym> Parameters' => 
		'<acronym title="Universal Resource Locator">URL</acronym>-parameters',

		'Type' => 
		'Type',

		'None found.' => 
		'Niets gevonden',

		'With Selected...' => 
		'Met geselecteerde...',

		'Apply' => 
		'Toepassen',

		// for Symphony 2.0.6 but replaced afterwards
		'%s %s at %s. <a href="%s">View all %s</a>' => 
		'%1$s %3$s %2$s. <a href="%4$s">Bekijk alle %5$s</a>',
		
		'%s %s at %s. <a href="%s">Create another?</a> <a href="%s">View all %s</a>' => 
		'%1$s %3$s %2$s. <a href="%4$s">Maak er nog één.</a> <a href="%5$s">Bekijk alle %6$s</a>',
		
		// begin for Symphony v2.0.6 integration and up
		'Page updated at %s. <a href="%s">View all Pages</a>' =>
		'Pagina %s bijgewerkt. <a href="%s">Bekijk alle pagina\'s</a>',
		
		'Page updated at %1$s. <a href="%2$s">Create another?</a> <a href="%3$s">View all Pages</a>' =>
		'Pagina %1$s bijgewerkt. <a href="%2$s">Maak er nog één.</a> <a href="%3$s">Bekijk alle pagina\'s</a>',
		
		'Page created at %1$s. <a href="%2$s">Create another?</a> <a href="%3$s">View all Pages</a>' =>
		'Pagina %1$s gemaakt. <a href="%2$s">Maak er nog één.</a> <a href="%3$s">Bekijk alle pagina\'s</a>',
		
		// end for Symphony v2.0.6 integration and up
		
		'Page' => 
		'Pagina',

		'Body is a required field.' => 
		'Inhoud is een vereist veld.',

		'This document is not well formed. The following error was returned: <code>%s</code>' => 
		'Dit document is niet goed gevormd. De volgende fout werd geretourneerd: <code>%s</code>',

		'Utility could not be written to disk. Please check permissions on <code>/workspace/utilities</code>.' => 
		'Bouwsteen kon niet naar schijf geschreven worden. Controleer de machtigingen op <code>/workspace/utilities</code>.',

		'Page not found' => 
		'Pagina niet gevonden',

		'The page you requested to edit does not exist.' => 
		'De pagina die u wilt bewerken bestaat niet.',

		'Page Settings' => 
		'Pagina-instellingen',

		'URL Handle' => 
		'URL-identifier',

		'URL Parameters' => 
		'URL-parameters',

		'Page Resources' => 
		'Paginahulpmiddelen',

		'Create Page' => 
		'Maak pagina',

		'Delete this page' => 
		'Verwijder deze pagina',

		'Title is a required field' => 
		'Titel is een vereist veld',

		'An index type page already exists.' => 
		'Er bestaat al een pagina van het type index.',

		'A 404 type page already exists.' => 
		'Er bestaat al een pagina van het type 404.',

		'A 403 type page already exists.' => 
		'Er bestaat al een pagina van het type 403.',

		'Page could not be written to disk. Please check permissions on <code>/workspace/pages</code>.' => 
		'Pagina kon niet naar schijf geschreven worden. Controleer de machtigingen op <code>/workspace/pages</code>.',

		'A page with that title already exists' => 
		'Er bestaat al een pagina met deze titel',

		'A page with that handle already exists' => 
		'Er bestaat al een pagina met deze identifier',

		'Unknown errors occurred while attempting to save. Please check your <a href="%s">activity log</a>.' => 
		'Er zijn onbekende fouten opgetreden bij de poging om op te slaan. Controleer uw <a href="%s">activiteitenlogboek</a>.',

		'Page could not be deleted because it does not exist.' => 
		'Pagina kan niet verwijderd worden omdat deze niet bestaat.',

		'Page could not be deleted because it has children.' => 
		'Pagina kan niet verwijderd worden omdat deze ondergeschikten heeft.',

		'One or more pages could not be deleted. Please check permissions on <code>/workspace/pages</code>.' => 
		'Één of meer pagina\s kunnen niet verwijderd worden. Controleer de machtigingen op <code>/workspace/pages</code>.',

		'Create a section' => 
		'Maak een sectie',

		'Entries' => 
		'Items',

		'Navigation Group' => 
		'Navigatiegroep',

		'Delete Entries' => 
		'Verwijder items',

		'%s Hide this section from the Publish menu' => 
		'%s Verberg deze sectie van het publicatiemenu',

		'Fields' => 
		'Velden',

		'Create Section' => 
		'Maak sectie',

		'Unknown Section' => 
		'Onbekende sectie',

		'The Section you are looking for could not be found.' => 
		'De sectie die u probeert te vinden kon niet gevonden worden.',

		'Section updated at %1$s. <a href="%2$s">Create another?</a> <a href="%3$s">View all Sections</a>' => 
		'Sectie %1$s bijgewerkt. <a href="%2$s">Maak er nog één.</a> <a href="%3$s">Bekijk alle secties</a>',

		'Section created at %1$s. <a href="%2$s">Create another?</a> <a href="%3$s">View all Sections</a>' => 
		'Sectie %1$s gemaakt. <a href="%2$s">Maak er nog één.</a> <a href="%3$s">Bekijk alle secties</a>',

		'Delete this section' => 
		'Verwijder deze sectie',

		'This is a required field.' => 
		'Dit is een vereist veld.',

		'A Section with the name <code>%s</code> name already exists' => 
		'Een sectie met <code>%s</code> als naam bestaat al',

		'Two custom fields have the same element name. All element names must be unique.' => 
		'Twee velden hebben dezelfde elementnaam. Alle elementnamen moeten uniek zijn.',

		'There is already a field of type <code>%s</code>. There can only be one per section.' => 
		'Er is al een veld met type <code>%s</code>. Er kan er maar één per sectie zijn.',

		'An unknown database occurred while attempting to create the section.' => 
		'Er is een onbekende databasefout opgetreden bij het maken van de sectie.',

		'Utility updated at %1$s. <a href="%2$s">Create another?</a> <a href="%3$s">View all Utilities</a>' => 
		'Bouwsteen %1$s bijgewerkt. <a href="%2$s">Maak er nog één.</a> <a href="%3$s">Bekijk alle bouwstenen</a>',

		'Utility created at %1$s. <a href="%2$s">Create another?</a> <a href="%3$s">View all Utilities</a>' => 
		'Bouwsteen %1$s gemaakt. <a href="%2$s">Maak er nog één.</a> <a href="%3$s">Bekijk alle bouwstenen</a>',

		'new' => 
		'nieuw',

		'Create Utility' => 
		'Maak bouwsteen',

		'Delete this utility' => 
		'Verwijder deze bouwsteen',

		'Name is a required field.' => 
		'Naam is een vereist veld.',

		'A Utility with that name already exists. Please choose another.' => 
		'Er bestaat al een bouwsteen met deze naam. Kies een andere naam.',

		'Login' => 
		'Inloggen',

		'An email containing a customised login link has been sent. It will expire in 2 hours.' => 
		'Een e-mail met een persoonlijke inloglink is verstuurd. De inloglink zal 2 uur geldig zijn.',

		'Enter your email address to be sent a remote login link with further instructions for logging in.' => 
		'Vul uw e-mailadres in om een inloglink toegestuurd te krijgen met verdere instructies om in te loggen.',

		'Email Address' => 
		'E-mailadres',

		'There was a problem locating your account. Please check that you are using the correct email address.' => 
		'Er is een probleem opgetreden bij het vinden van uw account. Controleer of u het juiste e-mailadres gebruikt.',

		'New Password' => 
		'Nieuw wachtwoord',

		'Confirm New Password' => 
		'Bevestig nieuw wachtwoord',

		'The supplied password was rejected. Make sure it is not empty and that password matches password confirmation.' => 
		'Het opgegeven wachtwoord is geweigerd. Zorg ervoor dat het wachtwoord ingevuld is en overeenkomt met de wachtwoordbevestiging.',

		'Password' => 
		'Wachtwoord',

		'The supplied password was rejected. <a href="%s">Retrieve password?</a>' => 
		'Het opgegeven wachtwoord is geweigerd. <a href="%s">Wachtwoord vergeten?</a>',

		'Symphony Concierge' => 
		'Symphonyconciërge',

		'New Symphony Account Password' => 
		'Nieuw wachtwoord voor Symphonygebruiker',

		'Hi %s,' => 
		'Hallo %s,',

		'A new password has been requested for your account. Login using the following link, and change your password via the Authors area:' => 
		'Er is een nieuw wachtwoord aangevraagd voor uw account. Log in via de volgende link en verander uw wachtwoord via het auteursgedeelte:',

		'It will expire in 2 hours. If you did not ask for a new password, please disregard this email.' => 
		'De link zal verlopen in 2 uur. Negeer deze e-mail als u geen nieuw wachtwoord heeft aangevraagd.',

		'Best Regards,' => 
		'Met vriendelijke groeten,',

		'The Symphony Team' => 
		'Het Symphony Team',

		'The Section you are looking, <code>%s</code> for could not be found.' => 
		'De sectie <code>%s</code> die u zoekt kan niet gevonden worden.',

		'Create a new entry' => 
		'Maak een nieuw item',

		'Sort by %1$s %2$s' => 
		'Sorteer op %1$s %2$s',

		'Set %s' => 
		'Stel %s in',

		'First' => 
		'Eerste',

		'&larr; Previous' => 
		'&larr; Vorige',

		'Page %1$s of %2$s' => 
		'Pagina %1$s van %2$s',

		'Viewing %1$s - %2$s of %3$s entries' => 
		'%1$s - %2$s van %3$s items aan het bekijken',

		'Next &rarr;' => 
		'Volgende &rarr;',

		'Last' => 
		'Laatste',

		'It looks like your trying to create an entry. Perhaps you want fields first? <a href="%s">Click here to create some.</a>' => 
		'Het lijkt er op dat u een item probeert te maken. Misschien wilt u eerst velden? <a href="%s">Klik hier om er een paar te maken.</a>',

		'Create Entry' => 
		'Maak item',

		'Some errors were encountered while attempting to save.' => 
		'Enkele fouten zijn opgetreden bij de poging om op te slaan.',

		'The Section you are looking for, <code>%s</code>, could not be found.' => 
		'De sectie waar u naar op zoek bent, <code>%s</code>, kan niet gevonden worden.',

		'Unknown Entry' => 
		'Item onbekend',

		'The entry you are looking for could not be found.' => 
		'Het item waar u naar op zoek bent kan niet gevonden worden.',

		'Entry updated at %1$s. <a href="%2$s">Create another?</a> <a href="%3$s">View all Entries</a>' => 
		'Item %1$s bijgewerkt. <a href="%2$s">Maak er nog één.</a> <a href="%3$s">Bekijk alle items</a>',

		'Entry created at %1$s. <a href="%2$s">Create another?</a> <a href="%3$s">View all Entries</a>' => 
		'Item %1$s gemaakt. <a href="%2$s">Maak er nog één.</a> <a href="%3$s">Bekijk alle items</a>',

		'It looks like your trying to create an entry. Perhaps you want custom fields first? <a href="%s">Click here to create some.</a>' => 
		'Het lijkt er op dat u een item probeert te maken. Misschien wilt u eerst velden? <a href="%s">Klik hier om er een paar te maken.</a>',

		'Delete this entry' => 
		'Verwijder dit item',

		'Add an Author' => 
		'Voeg een auteur toe',

		'Add a new author' => 
		'Voeg een nieuwe auteur toe',

		'Last Seen' => 
		'Laatst gezien',

		'Author updated at %1$s. <a href="%2$s">Create another?</a> <a href="%3$s">View all Authors</a>' => 
		'Auteur %1$s bijgewerkt. <a href="%2$s">Maak er nog één.</a> <a href="%3$s">Bekijk alle auteurs</a>',

		'Author created at %1$s. <a href="%2$s">Create another?</a> <a href="%3$s">View all Authors</a>' => 
		'Auteur %1$s gemaakt. <a href="%2$s">Maak er nog één.</a> <a href="%3$s">Bekijk alle auteurs</a>',

		'Login Details' => 
		'Inlogdetails',

		'Developer' => 
		'Ontwikkelaar',

		'Old Password' => 
		'Oude wachtwoord',

		'Confirm Password' => 
		'Bevestig wachtwoord',

		'Leave password fields blank to keep the current password' => 
		'Laat wachtwoordvelden leeg om het huidige wachtwoord te behouden',

		'%1$s Allow remote login via <a href="%2$s">%2$s</a>' => 
		'%1$s Sta inloggen via <a href="%2$s">%2$s</a> toe',

		'Default Section' => 
		'Standaardsectie',

		'Create Author' => 
		'Maak auteur',

		'Delete this author' => 
		'Verwijder deze auteur',

		'Passwords did not match' => 
		'Wachtwoorden komen niet overeen',

		'There were some problems while attempting to save. Please check below for problem fields.' => 
		'Er zijn enkele problemen opgetreden tijdens de poging om op te slaan. Controleer hieronder of er velden zijn met problemen.',

		'Wrong password. Enter old password to change it.' => 
		'Wachtwoord onjuist. Geef het oude wachtwoord op om het te veranderen',

		'Wrong password. Enter old one to change email address.' => 
		'Wachtwoord onjuist. Geef het oude wachtwoord op om het e-mailadres te veranderen.',

		'Extensions' => 
		'Uitbreidingen',

		'Enabled' => 
		'Geactiveerd',

		'Version' => 
		'Versie',

		'Yes' => 
		'Ja',

		'No' => 
		'Nee',

		'Enable' => 
		'Activeer',

		'Disable' => 
		'Deactiveer',

		'Uninstall' => 
		'Deïnstalleer',

		'Preferences' => 
		'Voorkeuren',

		'The Symphony configuration file, <code>/manifest/config.php</code>, is not writable. You will not be able to save changes to preferences.' => 
		'Het Symphony-configurationbestand, <code>/manifest/config.php</code>, is niet beschrijfbaar. Het zal niet mogelijk zijn om veranderingen van je voorkeuren op te slaan.',

		'Preferences saved.' => 
		'Voorkeuren opgeslagen',

		'Database Error' => 
		'Databasefout',

		'Symphony Database Error' => 
		'Symphony databasefout',

		'XSLT Processing Error' => 
		'XSLT-uitvoeringsfout',

		'This page could not be rendered due to the following XSLT processing errors.' => 
		'Deze pagina kan niet getoond worden vanwege de volgende XSLT-uitvoeringsfouten.',

		'<a href="%s" title="Show debug view">Compile</a>' => 
		'<a href="%s" title="Toon foutenoplossingsscherm">Compile</a>', // WAT IS DIT?

		'General' => 
		'Algemeen',

		'<a href="%1$s" title="Show debug view for %2$s">Line %3$d</a>' => 
		'<a href="%1$s" title="Toon foutenoplossingsscherm voor %2$s">Regel %3$d</a>',

		'Line %s' => 
		'Regel $s',

		'XML' => 
		'XML',

		'Access Denied' => 
		'Verboden toegang',

		'You are not authorised to access this page.' => 
		'U bent niet bevoegd om deze pagina te betreden.',

		'Logout' => 
		'Uitloggen',

		'You are not authorised to access this section.' => 
		'U bent niet bevoegd om deze sectie te betreden.',

		'Could not add directory "%s".' => 
		'Kon map "%s" niet toevoegen.',

		'Could not add file "%s".' => 
		'Kon bestand "%s" niet toevoegen.',

		'First name is required' => 
		'Voornaam is vereist',

		'Last name is required' => 
		'Achternaam is vereist',

		'E-mail address is required' => 
		'E-mailadres is vereist',

		'E-mail address entered is invalid' => 
		'Ingevulde e-mailadres is ongeldig',

		'Username is required' => 
		'Gebruikersnaam is vereist',

		'Username is already taken' => 
		'Gebruikersnaam is al in gebruik',

		'Password is required' => 
		'Wachtwoord is vereist',

		'Page Not Found' => 
		'Pagina niet gevonden',

		'The page you requested does not exist.' => 
		'De door u opgevraagde pagina bestaat niet.',

		'%s is not a valid object. Failed to append to XML.' => 
		'%s is een ongeldig object. Kon het niet toevoegen aan XML.',

		'No records found.' => 
		'Geen items gevonden',

		'Could not find Data Source <code>%s</code>. If the Data Source was provided by an Extensions, ensure that it is installed, and enabled.' => 
		'Kon gegevensbron <code>%s</code> niet vinden. Controleer als de gegevensbron door een uitbreiding geleverd wordt of deze geïnstalleerd en geactiveerd is.',

		'Edit' => 
		'Bewerk',

		'name' => 
		'naam',

		'Utility' => 
		'Bouwsteen',

		'No suitable engine object found' => 
		'Geen geschikt motorobject gevonden',

		'Entry limit specified was not a valid type. String or Integer expected.' => 
		'Opgegeven itemlimiet heeft een ongeldig type. Een string of integer wordt verwacht.',

		'Could not find Event <code>%s</code>. If the Event was provided by an Extensions, ensure that it is installed, and enabled.' => 
		'Kon gebeurtenis <code>%s</code> niet vinden. Controleer als de gebeurtenis door een uitbreiding geleverd wordt of deze geïnstalleerd en geactiveerd is.',

		'Could not %1$s %2$s, there was a problem loading the object. Check the driver class exists.' => 
		'Kon niet %1$s %2$s door een probleem met het laden van het object. Controleer of de driverklasse bestaat.', // WAT? misschien 2 eerst!

		'Could not find extension at location %s' => 
		'Kan uitbreiding niet vinden op locatie %s',

		'Invalid element name. Must be valid QName.' => 
		'Ongeldige elementnaam. Moet geldige QName zijn.',

		'A field with that element name already exists. Please choose another.' => 
		'Een veld met deze elementnaam bestaat al. Kies een andere naam.',

		'\'%s\' is a required field.' => 
		'\'%s\' is een vereist veld.',

		'Label' => 
		'Label',

		'%s Make this a required field' => 
		'%s Maak dit een vereist veld',

		'%s Show column' => 
		'%s Toon kolom',

		'Placement' => 
		'Plaatsing',

		'Main content' => 
		'Hoofdinhoud',

		'Sidebar' => 
		'Zijkant',

		'Formatting' => 
		'Opmaak', // WAT?

		'Validation Rule <i>Optional</i>' => 
		'Validatieregel <i>Optioneel</i>',

		'Data source output grouping is not supported by the <code>%s</code> field' => 
		'Groepering van gegevensbronuitvoer wordt niet ondersteund door het <code>%s</code>-veld.',

		'Could not find Field <code>%1$s</code> at <code>%2$s</code>. If the Field was provided by an Extension, ensure that it is installed, and enabled.' => 
		'Kon veld <code>%1$s</code> niet vinden op <code>%2$s</code>. Controleer als het veld door een uitbreiding geleverd wordt of deze geïnstalleerd en geactiveerd is.',

		'Forbidden' => 
		'Niet toegestaan',

		'Please <a href="%s">login</a> to view this page.' => 
		'U moet <a href="%s">inloggen</a> om deze pagina te bekijken.',

		'Large' => 
		'Groot',

		'Small' => 
		'Klein',

		'Hot' => 
		'Warm',

		'Cold' => 
		'Koud',

		'Big' => 
		'Groot',

		'Hairy' => 
		'Harig',

		'Round' => 
		'Rond',

		'Lumpy' => 
		'Gebobbeld',

		'Coconut' => 
		'Kokosnoot',

		'Encumbered' => 
		'Overvallen',

		'Cats' => 
		'Katten',

		'Dogs' => 
		'Honden',

		'Weasels' => 
		'Wezels',

		'Birds' => 
		'Vogels',

		'Worms' => 
		'Wormen',

		'Bugs' => 
		'Kevers',

		'Pigs' => 
		'Varkens',

		'Monkeys' => 
		'Apen',

		'Pirates' => 
		'Piraten',

		'Aardvarks' => 
		'Aardvarkens',

		'Men' => 
		'Mannen',

		'Women' => 
		'Vrouwen',

		'Unable to remove file - %s' => 
		'Kan bestand niet verwijderen - %s',

		'MySQL Error (%1$s): %2$s in query "%3$s"' => 
		'MySQL-fout (%1$s): %2$s in query "%3$s"',

		'Can\'t open file %s' => 
		'Kan bestand %s niet openen',

		'Could not find Text Formatter <code>%s</code>. If the Text Formatter was provided by an Extensions, ensure that it is installed, and enabled.' => 
		'Kon tekstopmaker <code>%s</code> niet vinden. Controleer als de tekstopmaker door een uitbreiding geleverd wordt of deze geïnstalleerd en geactiveerd is',

		'No suitable XSLT processor was found.' => 
		'Er is geen geschikte XSLT-processor gevonden.',

		'No <code>/symphony</code> directory was found at this location. Please upload the contents of Symphony\'s install package here.' => 
		'Er is geen <code>/symphony</code> map gevinden op deze locatie. Upload de inhoud van Symphony\'s installatiepakket hier naar toe.',

		'Symphony does not have write permission to the existing <code>/workspace</code> directory. Please modify permission settings on this directory and its contents to allow this, such as with a recursive <code>chmod -R</code> command.' => 
		'Symphony heeft geen toesteming om de bestaande <code>/workspace</code> map te beschrijven. Pas de machtigingsinstellingen van deze map en haar inhoud aan om dit toe te staan, bijvoorbeeld met een recursief <code>chmod -R</code> commando.',

		'Symphony does not have write permission to the <code>/manifest</code> directory. Please modify permission settings on this directory and its contents to allow this, such as with a recursive <code>chmod -R</code> command.' => 
		'Symphony heeft geen toesteming om de bestaande <code>/manifest</code> map te beschrijven. Pas de machtigingsinstellingen van deze map en haar inhoud aan om dit toe te staan, bijvoorbeeld met een recursief <code>chmod -R</code> commando.',

		'Symphony does not have write permission to the root directory. Please modify permission settings on this directory. This is necessary only if you are not including a workspace, and can be reverted once installation is complete.' => 
		'Symphony heeft geen toestemming om de hoofdmap te beschrijven. Pas de machtigingsinstellingen van deze map aan. Dit is alleen nodig als u geen werkmap heeft toegevoegd en kan ongedaan worden gemaakt na de installatie.',

		'Symphony does not have write permission to the temporary <code>htaccess</code> file. Please modify permission settings on this file so it can be written to, and renamed.' => 
		'Symphony heeft geen toestemming om het tijdelijke <code>htaccess</code> bestand te beschrijven. Pas de machtigingsinstellingen van dit bestand aan zodat het beschreven en hernoemd kan worden.',

		'Symphony does not have write permission to the <code>/symphony</code> directory. Please modify permission settings on this directory. This is necessary only during installation, and can be reverted once installation is complete.' => 
		'Symphony heeft geen toestemming om te schrijven naar de <code>/symphony</code> map. Pas de machtigingsinstellingen van deze map aan. Dit is alleen nodig tijdens de isntallatie en kan ongedaan worden gemaakt na de installatie.',

		'There appears to be an existing <code>.htaccess</code> file in the Symphony install location. To avoid name clashes, you will need to delete or rename this file.' => 
		'Er blijkt een bestaand <code>.htaccesss</code> bestand te zijn op de installatielocatie van Symphony. Om naamconflicten te voorkomen zal u dit bestand moeten verwijderen of hernoemen.',

		'There appears to be an existing <code>.htaccess</code> file in the <code>/symphony</code> directory.' => 
		'Er blijkt een bestaand <code>.htaccess</code> bestand te zijn in de <code>/symphony</code> map.',

		'Symphony was unable to connect to the specified database. You may need to modify host or port settings.' => 
		'Symphony kon geen verbinding maken met de opgegeven database. Controleer de host- en poortinstellignen.',

		'Symphony requires <code>MySQL 4.1</code> or greater to work. This requirement must be met before installation can proceed.' => 
		'Symphony vereist <code>MySQL 4.1</code> of nieuwer om te werken. De installatie kan alleen uitgevoerd worden als hier aan wordt voldaan.',

		'The table prefix <code><!-- TABLE-PREFIX --></code> is already in use. Please choose a different prefix to use with Symphony.' => 
		'The tabelprefix <code><!-- TABLE-PREFIX --></code> is al in gebruik. Kies een andere prefix om te gebruiken met Symphony.',

		'The password and confirmation did not match. Please retype your password.' => 
		'Het wachtwoord en de bevestiging kwam niet overeen. Probeer het opnieuw.',

		'This is not a valid email address. You must provide an email address since you will need it if you forget your password.' => 
		'Dit is geen geldig e-mailadres. U moet een e-mailadres opgegeven voor het geval dat u uw wachtwoord vergeet.',

		'You must enter a Username. This will be your Symphony login information.' => 
		'U moet een gebruikersnaam opgeven. Deze heeft u nodig om in te loggen op Symphony.',

		'You must enter a Password. This will be your Symphony login information.' => 
		'U moet een wachtwoord opgeven. Deze heeft u nodig om te loggen bij Symphony.',

		'You must enter your name.' => 
		'U moet een naam opgeven.',

		'An existing <code>/workspace</code> directory was found at this location. Symphony will use this workspace.' => 
		'Een bestaande <code>/workspace</code> map is gevonden op deze locatie. Symphony zal deze werkmap gebruiken.',

		'Symphony requires <code>MySQL 4.1</code> or greater to work, however version <code>%s</code> was detected. This requirement must be met before installation can proceed.' => 
		'Symphony vereist <code>MySQL 4.1</code> of nieuwer om te werken, maar versie <code>%s</code> is gedetecteerd. De installatie kan alleen uitgevoerd worden als hier aan wordt voldaan.',

		'Website Name' => 
		'Websitenaam',

		'Environment Settings' => 
		'Omgevingsinstellingen',

		'Symphony is ready to be installed at the following location.' => 
		'Symphony is gereed om geïnstalleerd te worden op de volgende locatie.',

		'Root Path' => 
		'Hoofdpad',

		'Website Preferences' => 
		'Websitevoorkeuren',

		'Date and Time' => 
		'Datum en tijd',

		'Customise how Date and Time values are displayed throughout the Administration interface.' => 
		'Geef uw voorkeuren op voor het weergeven van datum- en tijdwaarden op het beheerscherm.',

		'Region' => 
		'Regio',

		'Date Format' => 
		'Datumnotatie',

		'Time Format' => 
		'Tijdnotatie',

		'Database Connection' => 
		'Databaseverbinding',

		'Please provide Symphony with access to a database.' => 
		'Geef Symphony toegang tot een database.',

		'Database' => 
		'Database',

		'Advanced Configuration' => 
		'Geavanceerde configuratie',

		'Leave these fields unless you are sure they need to be changed.' => 
		'Laat deze velden met rust als je niet zeker weet of ze veranderd moeten worden.',

		'Host' => 
		'Host',

		'Port' => 
		'Poort',

		'Table Prefix' => 
		'Tabelprefix',

		'Use compatibility mode' => 
		'Gebruik compabiliteitsmodus',

		'Symphony normally specifies UTF-8 character encoding for database entries. With compatibility mode enabled, Symphony will instead use the default character encoding of your database.' => 
		'Symphony gebruikt normaal UTF-8 voor karaktercodering van database items. Als compabiliteitsmodus geactiveerd is zal Symphony de standaard karaktercodering van uw database gebruiken.',

		'Permission Settings' => 
		'Machtigingsinstellingen',

		'Symphony needs permission to read and write both files and directories.' => 
		'Symphony heeft toegang nodig om mappen en bestanden te lezen en te beschrijven.',

		'Files' => 
		'Bestanden',

		'Directories' => 
		'Mappen',

		'User Information' => 
		'Gebruikersinformatie',

		'Once installed, you will be able to login to the Symphony admin with these user details.' => 
		'Als de installatie is voltooid kan u inloggen op het Symphony-beheerscherm met deze gebruikersgegevens.',

		'Personal Information' => 
		'Persoonlijke informatie',

		'Please add the following personal details for this user.' => 
		'Vul de volgende persoonlijke informatie in voor deze gebruiker.',

		'Install Symphony' => 
		'Installeer Symphony',

		'Make sure that you delete <code>' => 
		'Zorg dat je het <code>',

		'</code> file after Symphony has installed successfully.' => 
		'</code> bestand verwijderd nadat Symphony succesvol is geinstalleerd.',

		'Version %s' => 
		'Versie %s',

		'Outstanding Requirements' => 
		'Voldoe aan de eisen',

		'Symphony needs the following requirements satisfied before installation can proceed.' => 
		'Symphony heeft de volgende eisen waaraan voldaan moet worden voordat de installatie verder kan gaan.',

		'<abbr title="PHP: Hypertext Pre-processor">PHP</abbr> 5.1 or above' => 
		'<abbr title="PHP: Hypertext Pre-processor">PHP</abbr> 5.1 of nieuwer',

		'Symphony needs a recent version of <abbr title="PHP: Hypertext Pre-processor">PHP</abbr>.' => 
		'Symphony heeft een recente versie van <abbr title="PHP: Hypertext Pre-processor">PHP</abbr> nodig.',

		'My<abbr title="Structured Query Language">SQL</abbr> 4.1 or above' => 
		'My<abbr title="Structured Query Language">SQL</abbr> 4.1 of nieuwer',

		'Symphony needs a recent version of My<abbr title="Structured Query Language">SQL</abbr>.' => 
		'Symphony heeft een recente versie van My<abbr title="Structured Query Language">SQL</abbr> nodig.',

		'ZLib Compression Library' => 
		'ZLib-compressiebibliotheek',

		'Data retrieved from the Symphony support server is decompressed with the ZLib compression library.' => 
		'Data opgevraagd van de Symphony ondersteuningsserver',

		'<abbr title="eXtensible Stylesheet Language Transformation">XSLT</abbr> Processor' => 
		'<abbr title="eXtensible Stylesheet Language Transformation">XSLT</abbr>-processor',

		'Symphony needs an XSLT processor such as Lib<abbr title="eXtensible Stylesheet Language Transformation">XSLT</abbr> or Sablotron to build pages.' => 
		'Symphony heeft een XSLT-processor zoals Lib<abbr title="eXtensible Stylesheet Language Transformation">XSLT</abbr> of Sablotron nodig om pagina\'s te genereren.',

		'Missing Requirements' => 
		'Onvoldane eisen',

		'Update Symphony' => 
		'Update Symphony',

		'You are already using the most recent version of Symphony. There is no need to run the installer, and can be safely deleted.' => 
		'Het lijkt er op dat u de recentste versie van Symphony al gebruik. U hoeft het installatieprogramma niet te gebruiken en het kan veilig verwijderd worden.',

		'You are not using the most recent version of Symphony. This update is only compatible with Symphony 2.' => 
		'U gebruikt niet de recentste versie van Symphony. Deze update werkt alleen met Symphony 2.',

		'Installation Failure' => 
		'Installatiefout',

		'An error occurred during installation. You can view you log <a href="install-log.txt">here</a> for more details.' => 
		'Er is een fout opgetreden tijdens de installatie. Bekijk het logboek <a href="install-log.txt">hier</a> voor meer informatie.',

		'XML returned is invalid.' => 
		'Teruggegeven XML is ongeldig.',

		'Error creating field object with id %1$d, for filtering in data source "%2$s". Check this field exists.' => 
		'Fout bij het maken van veldobject met id %1$d bij het filteren van gegevens bron "%2$s". Controleer of het veld bestaat.',

		'The section associated with the data source <code>%s</code> could not be found.' => 
		'De sectie geassocieerd met gegevensbron <code>%s</code kan niet gevonden worden.',

		'Section is invalid' => 
		'Sectie is ongeldig.',

		'Invalid Entry ID specified. Could not create Entry object.' => 
		'Ongeldig item-ID opgegeven. Kon itemobject niet maken.',

		'Unknown errors where encountered when saving.' => 
		'Er zijn onbekende fouten opgetreden bij het opslaan.',

		'[Symphony] A new entry was created on %s' => 
		'[Symphony] Een nieuw item is gemaakt op %s',

		'Dear <!-- RECIPIENT NAME -->,' => 
		'Beste <!-- RECIPIENT NAME -->,',

		'This is a courtesy email to notify you that an entry was created on the %1$s section. You can edit the entry by going to: %2$s' => 
		'Deze e-mail is gestuurd om u te laten weten dat er een item is gemaakt in de %1$s sectie. Dit item kan bewerkt worden via: %2$s',

		'No valid recipients found. Check send-email[recipient] field.' => 
		'Geen geldige ontvangers gevonden. Controleer het send-email[recipient] veld.',

		'Entry edited successfully.' => 
		'Item succesvol bewerkt.',

		'Entry created successfully.' => 
		'Item succesvol gemaakt.',

		'%s Allow selection of multiple authors' => 
		'%s Sta selectie van meerdere auteurs toe',

		'%s Select current user by default' => 
		'%s Selecteer standaard de huidige gebruiker.',

		'Checkbox' => 
		'Aanvinkvak',

		'Long Description <i>Optional</i>' => 
		'Lange omschrijving <i>Optioneel</i>',

		'%s Checked by default' => 
		'%s Standaard aangevinkt',

		'Date' => 
		'Datum',

		'The date specified in \'%s\' is invalid.' => 
		'De datum opgegeven bij \'%s\' is ongeldig.',

		'%s Pre-populate this field with today\'s date' => 
		'%s Vul dit veld standaard met de datum van vandaag',

		'Text Input' => 
		'Tekstinvoer',

		'\'%s\' contains invalid data. Please check the contents.' => 
		'\'%s\' bevat ongeldige gegevens. Controleer de inhoud.',

		'"%1$s" contains invalid XML. The following error was returned: <code>%2$s</code>' => 
		'"%1$s" bevat ongeldige XML. De volgende fout is geretourneerd: <code>%2$s</code>',

		'Select Box' => 
		'Selectiebox',

		'At least one source must be specified, dynamic or static.' => 
		'Er moet tenminste één gegevensbron opgegeven worden, dynamisch of statisch.',

		'Static Options' => 
		'Statische opties',

		'Dynamic Options' => 
		'Dynamische opties',

		'%s Allow selection of multiple options' => 
		'%s Sta het toe om meerdere opties te selecteren',

		'Tag List' => 
		'Etikettenlijst',

		'Suggestion List' => 
		'Suggestielijst',

		'Existing Values' => 
		'Bestaande waarden',

		'Textarea' => 
		'Tekstvak',

		'Make textarea %s rows tall' => 
		'Maak tekstvak %s regels hoog',

		'File Upload' => 
		'Upload bestand',

		'The destination directory, <code>%s</code>, does not exists.' => 
		'Doelmap <code>%s</code bestaat niet.',

		'Destination folder, <code>%s</code>, is not writable. Please check permissions.' => 
		'Doelmap <code>%s</code> is niet schrijfbaar. Controleer machtigingen.',

		'Directory <code>%s</code> does not exists.' => 
		'Map <code>%s</code bestaat niet.',

		'Destination Directory' => 
		'Bestemmingsmap',

		'File chosen in "%1$s" exceeds the maximum allowed upload size of %2$s specified by your host.' => 
		'Bestand gekozen bij "%1$s" overschrijdt de maximum toegestane uploadgrootte van %2$s opgegeven door uw webhost.',

		'File chosen in "%1$s" exceeds the maximum allowed upload size of %2$s, specified by Symphony.' => 
		'Bestand gekozen bij "%1$s" overschrijdt de maximum toegestane uploadgrootte van %2$s opgegeven door Symphony.',

		'File chosen in \'%s\' was only partially uploaded due to an error.' => 
		'Bestand gekozen bij \'%s\' is door een fout deels geupload.',

		'Uploading \'%s\' failed. Could not write temporary file to disk.' => 
		'Uploaden van \'%s\' is niet gelukt. Kon tijdelijk bestand niet schrijven naar schijf.',

		'Uploading \'%s\' failed. File upload stopped by extension.' => 
		'Uploaden van \'%s\' is niet gelukt. Uploaden van bestand is tegengehouden door extensie.',

		'File chosen in \'%s\' does not match allowable file types for that field.' => 
		'Bestand gekozen bij \'%s\' komt niet overeen met de toegestane bestandstypen voor dit veld.',

		'A file with the name %1$s already exists in %2$s. Please rename the file first, or choose another.' => 
		'Een bestand met naam %1$s bestaat al in %2$s. Geef het bestand een andere naam of kies een ander bestand.',

		'There was an error while trying to upload the file <code>%1$s</code> to the target directory <code>%2$s</code>.' => 
		'Er is een fout opgetreden bij het uploaden van bestand <code>%1$s</code> naar doelmap <code>%2$s</code>',

		'Blueprints' => 
		'Blauwdruk',

	);
	
	
	/*
	 * CORE: Symphony
	 * Javascript strings
	 */

	$dictionary += array(
	
		// Missing translations

		'Untitled' => 
		'Naamloos',

		'Add item' => 
		'Voeg item toe',

		'Remove selected items' => 
		'Verwijder geselecteerde items',

		'Are you sure you want to {$action} {$name}?' => 
		'Weet u zeker dat u {$name} wilt {$action}?',

		'Are you sure you want to {$action} {$count} items?' => 
		'Weet u zeker dat u {$count} items wilt {$action}?',

		'Are you sure you want to {$action}?' => 
		'Weet u zeker dat u wilt {$action}?',

		'Reordering was unsuccessful.' => 
		'Herordenen is niet gelukt.',

		'Password' => 
		'Wachtwoord',

		'Change Password' => 
		'Verander wachtwoord',

		'Remove File' => 
		'Verwijder bestand',

		'at' => 
		'bij',

		'just now' => 
		'net',

		'a minute ago' => 
		'een minuut geleden',

		'{$minutes} minutes ago' => 
		'{$minutes} minuten geleden',

		'about 1 hour ago' => 
		'ongeveer 1 uur geleden',

		'about {$hours} hours ago' => 
		'ongeveer {$hours} uur geleden',

	);
	
	
	/*
	 * EXTENSION: Debug DevKit
	 * Localisation strings
	 */

	$dictionary += array(
	
		// Missing translations

		'Debug' => 
		'Foutenoplossing',

		'Params' => 
		'Parameters',

		'XML' => 
		'XML',

		'Result' => 
		'Resultaat',

	);
	
	
	/*
	 * EXTENSION: Export Ensemble
	 * Localisation strings
	 */

	$dictionary += array(
	
		// Missing translations

		'Existing Installation' => 
		'Bestaande installatie',

		'Install Symphony <em>Version %s</em>' => 
		'Installeer Symphony <em>versie %s</em>',

		'It appears that Symphony has already been installed at this location.' => 
		'Het lijkt er op dat Symphony al geïnstalleerd is op deze locatie.',

		'Export Ensemble cannot be installed, since the "<a href="http://php.net/manual/en/book.zip.php">ZipArchive</a>" class is not available. Ensure that PHP was compiled with the <code>--enable-zip</code> flag.' => 
		'Exporteerensemble kan niet worden geinstalleerd omdat de "<a href="http://php.net/manual/en/book.zip.php">ZIP-archief</a>" klasse niet beschikbaar is. Zorg dat PHP gecompileerd is met de <code>--enable-zip</code> optie.',

	);
	
	
	/*
	 * EXTENSION: JIT Image Manipulation
	 * Localisation strings
	 */

	$dictionary += array(
	
		// Missing translations

		'Error reading external image <code>%s</code>. Please check the URI.' => 
		'Fout bij het lezen van externe afbeelding <code>%s</code>. Controleer de URI.',

		'Error writing to temporary file <code>%s</code>.' => 
		'Fout bij het schrijven naar tijdelijk bestand <code>%s</code>',

		'Error loading image <code>%s</code>. Check it exists and is readable.' => 
		'Fout bij het laden van afbeelding <code>%s</code>. Controleer of deze bestaat en leesbaar is.',

		'Cannot load CMYK JPG Images' => 
		'Kan CMYK-JPG-afbeeldingen niet laden.',

		'Unsupported image type. Supported types: GIF, JPEG and PNG' => 
		'Afbeeldingstype wordt niet ondersteund. Ondersteunde typen zijn: GIF, JPEG en PNG',

		'Invalid image resource supplied' => 
		'Ongeldige afbeeldingsbron opgegeven',

		'Error: Connecting to that external site is not permitted.' => 
		'Fout: verbinden met deze externe site is niet toegestaan.',

		'Image <code>%s</code> could not be found.' => 
		'Afbeelding <code>%s</code> kon niet gevonden worden.',

		'Error generating image' => 
		'Fout bij het genereren van afbeelding',

	);
	
	
	/*
	 * EXTENSION: Localisation Manager
	 * Localisation strings
	 */

	$dictionary += array(
	
		// Missing translations

		'%1$s &ndash; %2$s' => 
		'%1$s &ndash; %2$s',

		'Symphony' => 
		'Symphony',

		'Localisation Manager' => 
		'Localisatiebeheer',

		'Language Manager' => 
		'Taalbeheer',

		'Export Settings' => 
		'Exporteerinstellingen',

		'Language' => 
		'Taal',

		'e. g. Deutsch, Français' => 
		'bijv. Deutsch, Français',

		'Language Code' => 
		'Taalcode',

		'e. g. de, fr' => 
		'bijv. de, fr',

		'If you enter details of an already existing language, your download will contain all current strings highlighting missing ones. <br />If you leave all fields blank, a clean, untranslated language file will be returned.' => 
		'Als u de details invult van een bestaande taal dan zal uw download alle huidige strings bevatten en alle missende strings gemarkeerd hebben. <br />Als u alle velden leeg laat dan zal er een nieuw onvertaald taalbestand worden geretourneerd.',

		'Download Language File' => 
		'Download taalbestand',

		'System Language' => 
		'Systeemtaal',

		'Authors can set up a differing language in their profiles.' => 
		'Auteurs kunnen verschillende talen kiezen in hun profiel.',

		'Custom Preferences' => 
		'Persoonlijke voorkeuren',

		'System Standard' => 
		'Systeemstandaard',

	);
	
	
	/*
	 * EXTENSION: Maintenance Mode
	 * Localisation strings
	 */

	$dictionary += array(
	
		// Missing translations

		'This site is currently in maintenance mode. <a href="%s/symphony/system/preferences/?action=toggle-maintenance-mode&amp;redirect=%s">Restore?</a>' => 
		'Deze site is op dit moment in onderhoudsmodus. <a href="%s/symphony/system/preferences/?action=toggle-maintenance-mode&amp;redirect=%s">Terugzetten?</a>',

	);
	
	
	/*
	 * EXTENSION: Profile DevKit
	 * Localisation strings
	 */

	$dictionary += array(
	
		// Missing translations

		'Profile' => 
		'Profiel',

		'General Details' => 
		'Algemene informatie',

		'Datasource Execution' => 
		'Uitvoering gegevensbronnen',

		'Event Execution' => 
		'Uitvoering gebeurtenissen',

		'Full Page Render Statistics' => 
		'Volledige paginageneratiestatistieken',

		'Slow Query Details' => 
		'Langzame databaseverzoeken',

		'Total Database Queries' => 
		'Totaal databaseverzoeken',

		'Slow Queries (> 0.09s)' => 
		'Langzame databaseverzoeken (> 0,09s)',

		'Total Time Spent on Queries' => 
		'Totale tijd besteed aan databaseverzoeken',

		'Time Triggering All Events' => 
		'Tijd om alle gebeurtenissen te starten',

		'Time Running All Data Sources' => 
		'Tijd voor uitvoering alle gegevensbronnen',

		'XML Generation Function' => 
		'XML-opbouw functie',

		'XSLT Generation' => 
		'XSLT-opbouw',

		'Output Creation Time' => 
		'Tijd voor maken uitvoer',

	);
	
	
	/*
	 * EXTENSION: Field: Select Box Link
	 * Localisation strings
	 */

	$dictionary += array(
	
		// Missing translations

		'Select Box Link' => 
		'Selectiebox-link',

		'Options' => 
		'Opties',

		'Limit to the %s most recent entries' => 
		'Limiteer tot de %s meest recente items',

		'Allow selection of multiple options' => 
		'Sta selectie van meerdere opties toe',

	);
	
	
	/*
	 * CORE: Symphony
	 * Transliterations
	 */

	$transliterations = array(
	
		// Alphabetic
		
		'/À/' => 'A',		'/Á/' => 'A',		'/Â/' => 'A',		'/Ã/' => 'A',		'/Ä/' => 'Ae',
		'/Å/' => 'A',		'/Ā/' => 'A',		'/Ą/' => 'A',		'/Ă/' => 'A',		'/Æ/' => 'Ae',
		'/Ç/' => 'C',		'/Ć/' => 'C',		'/Č/' => 'C',		'/Ĉ/' => 'C',		'/Ċ/' => 'C',
		'/Ď/' => 'D',		'/Đ/' => 'D',		'/Ð/' => 'D',		'/È/' => 'E',		'/É/' => 'E',
		'/Ê/' => 'E',		'/Ë/' => 'E',		'/Ē/' => 'E',		'/Ę/' => 'E',		'/Ě/' => 'E',
		'/Ĕ/' => 'E',		'/Ė/' => 'E',		'/Ĝ/' => 'G',		'/Ğ/' => 'G',		'/Ġ/' => 'G',
		'/Ģ/' => 'G',		'/Ĥ/' => 'H',		'/Ħ/' => 'H',		'/Ì/' => 'I',		'/Í/' => 'I',
		'/Î/' => 'I',		'/Ï/' => 'I',		'/Ī/' => 'I',		'/Ĩ/' => 'I',		'/Ĭ/' => 'I',
		'/Į/' => 'I',		'/İ/' => 'I',		'/Ĳ/' => 'Ij',		'/Ĵ/' => 'J',		'/Ķ/' => 'K',
		'/Ł/' => 'L',		'/Ľ/' => 'L',		'/Ĺ/' => 'L',		'/Ļ/' => 'L',		'/Ŀ/' => 'L',
		'/Ñ/' => 'N',		'/Ń/' => 'N',		'/Ň/' => 'N',		'/Ņ/' => 'N',		'/Ŋ/' => 'N',
		'/Ò/' => 'O',		'/Ó/' => 'O',		'/Ô/' => 'O',		'/Õ/' => 'O',		'/Ö/' => 'Oe',
		'/Ø/' => 'O',		'/Ō/' => 'O',		'/Ő/' => 'O',		'/Ŏ/' => 'O',		'/Œ/' => 'Oe',
		'/Ŕ/' => 'R',		'/Ř/' => 'R',		'/Ŗ/' => 'R',		'/Ś/' => 'S',		'/Š/' => 'S',
		'/Ş/' => 'S',		'/Ŝ/' => 'S',		'/Ș/' => 'S',		'/Ť/' => 'T',		'/Ţ/' => 'T',
		'/Ŧ/' => 'T',		'/Ț/' => 'T',		'/Ù/' => 'U',		'/Ú/' => 'U',		'/Û/' => 'U',
		'/Ü/' => 'Ue',		'/Ū/' => 'U',		'/Ů/' => 'U',		'/Ű/' => 'U',		'/Ŭ/' => 'U',
		'/Ũ/' => 'U',		'/Ų/' => 'U',		'/Ŵ/' => 'W',		'/Ý/' => 'Y',		'/Ŷ/' => 'Y',
		'/Ÿ/' => 'Y',		'/Y/' => 'Y',		'/Ź/' => 'Z',		'/Ž/' => 'Z',		'/Ż/' => 'Z',
		'/Þ/' => 'T',
		'/à/' => 'a',		'/á/' => 'a',		'/â/' => 'a',		'/ã/' => 'a',		'/ä/' => 'ae',
		'/å/' => 'a',		'/ā/' => 'a',		'/ą/' => 'a',		'/ă/' => 'a',		'/æ/' => 'ae',
		'/ç/' => 'c',		'/ć/' => 'c',		'/č/' => 'c',		'/ĉ/' => 'c',		'/ċ/' => 'c',
		'/ď/' => 'd',		'/đ/' => 'd',		'/ð/' => 'd',		'/è/' => 'e',		'/é/' => 'e',
		'/ê/' => 'e',		'/ë/' => 'e',		'/ē/' => 'e',		'/ę/' => 'e',		'/ě/' => 'e',
		'/ĕ/' => 'e',		'/ė/' => 'e',		'/ĝ/' => 'g',		'/ğ/' => 'g',		'/ġ/' => 'g',
		'/ģ/' => 'g',		'/ĥ/' => 'h',		'/ħ/' => 'h',		'/ì/' => 'i',		'/í/' => 'i',
		'/î/' => 'i',		'/ï/' => 'i',		'/ī/' => 'i',		'/ĩ/' => 'i',		'/ĭ/' => 'i',
		'/į/' => 'i',		'/ı/' => 'i',		'/ĳ/' => 'ij',		'/ĵ/' => 'j',		'/ķ/' => 'k',
		'/ł/' => 'l',		'/ľ/' => 'l',		'/ĺ/' => 'l',		'/ļ/' => 'l',		'/ŀ/' => 'l',
		'/ñ/' => 'n',		'/ń/' => 'n',		'/ň/' => 'n',		'/ņ/' => 'n',		'/ŋ/' => 'n',
		'/ò/' => 'o',		'/ó/' => 'o',		'/ô/' => 'o',		'/õ/' => 'o',		'/ö/' => 'oe',
		'/ø/' => 'o',		'/ō/' => 'o',		'/ő/' => 'o',		'/ŏ/' => 'o',		'/œ/' => 'oe',
		'/ŕ/' => 'r',		'/ř/' => 'r',		'/ŗ/' => 'r',		'/ś/' => 's',		'/š/' => 's',
		'/ş/' => 's',		'/ŝ/' => 's',		'/ș/' => 's',		'/ť/' => 't',		'/ţ/' => 't',
		'/ŧ/' => 't',		'/ț/' => 't',		'/ù/' => 'u',		'/ú/' => 'u',		'/û/' => 'u',
		'/ü/' => 'ue',		'/ū/' => 'u',		'/ů/' => 'u',		'/ű/' => 'u',		'/ŭ/' => 'u',
		'/ũ/' => 'u',		'/ų/' => 'u',		'/ŵ/' => 'w',		'/ý/' => 'y',		'/ŷ/' => 'y',
		'/ÿ/' => 'y',		'/y/' => 'y',		'/ź/' => 'z',		'/ž/' => 'z',		'/ż/' => 'z',
		'/þ/' => 't',		'/ß/' => 'ss',		'/ſ/' => 'ss',		'/ƒ/' => 'f',		'/ĸ/' => 'k',
		'/ŉ/' => 'n',

		// Symbolic

		'/\(/' => null,		'/\)/' => null,		'/,/' => null,
		'/–/' => '-',		'/－/' => '-',		'/„/' => '"',
		'/“/' => '"',		'/”/' => '"',		'/—/' => '-',

		// Ampersands

		'/^&(?!&)$/' => 'en',
		'/^&(?!&)/' => 'en-',
		'/&(?!&)&/' => '-en',
		'/&(?!&)/' => '-en-',

	);
	
