<?php
    require_once(EXTENSIONS . '/symql/lib/class.symql.php');

    require_once(TOOLKIT . '/class.datasource.php');

    Class datasourceNavigation_Submenus extends Datasource {

        /**
         *
         * name of the root XML element that wraps the data
         * @var string
         */
        public $dsParamROOTELEMENT = 'navigation-submenus';

        /**
         *
         * Credits method
         */
        public function about(){
            return array(
                     'name' => 'Navigation Submenus',
                     'version' => '1.0',
                     'release-date' => '2012-06-05',
                     'author' => array('name' => 'Jordy Boezaard',
                                       'website' => 'http://www.bitterzoetmedia.nl',
                                       'email' => 'jordy@bitterzoetmedia.nl')
            );
        }

        /**
         *
         * Class constructor
         * @param object $parent
         * @param array $env
         * @param boolean $process_params
         */
		  public function __construct(array $env = null, $process_params=true){
        //public function __construct(&$parent, Array $env = null, $process_params=true){
//            parent::__construct($parent, $env, $process_params);
            parent::__construct($env, $process_params);

        }

        /**
         *
         * Method called by Symphony in order to build the
         * @param $param_pool
         * @return XMLElement
         */
        public function grab(array &$param_pool = NULL)
        {
            // prepare output
            $result = new XMLElement($this->dsParamROOTELEMENT);
            
            // Query activiteiten
            $query = new SymQLQuery('published-activiteiten');
            $query
                ->select('titel, categorie')
                ->from('activiteiten')
                ->where('publiceer', 'yes')
                ->orderby('titel', 'asc')
                ->perPage(1000);

            $aResult = SymQL::run($query, SymQL::RETURN_ARRAY);
            
            $result->appendChild($this->generateXml('activiteiten', $aResult));
            
            // Query cursussen
            $query = new SymQLQuery('published-cursussen');
            $query
                ->select('titel, categorie')
                ->from('cursussen')
                ->where('publiceer', 'yes')
                ->orderby('titel', 'asc')
                ->perPage(1000);

            $aResult = SymQL::run($query, SymQL::RETURN_ARRAY);
            
            $result->appendChild($this->generateXml('cursussen', $aResult));
            
            // Query arrangementen
            $query = new SymQLQuery('published-arrangementen');
            $query
                ->select('titel, categorie')
                ->from('arrangementen')
                ->where('publiceer', 'yes')
                ->orderby('titel', 'asc')
                ->perPage(1000);

            $aResult = SymQL::run($query, SymQL::RETURN_ARRAY);
            
            $result->appendChild($this->generateXml('arrangementen', $aResult));
            
            // Query workshops
            $query = new SymQLQuery('published-workshops');
            $query
                ->select('titel, categorie')
                ->from('workshops')
                ->where('publiceer', 'yes')
                ->orderby('titel', 'asc')
                ->perPage(1000);

            $aResult = SymQL::run($query, SymQL::RETURN_ARRAY);
            
            $result->appendChild($this->generateXml('workshops', $aResult));
            
            // Return XML
            return $result;
        }
        
        private function generateXml($sRootXmlNodeTitle, $aResult)
        {
            // prepare output
            $result = new XMLElement($sRootXmlNodeTitle);
            
            // Data to process?
            if (isset($aResult['entries']) == false
                || count($aResult['entries']) == 0)
            {
                return $result;
            }
            
            // Parse results and divide in categories
            $aCategories = array();
                            
            foreach ($aResult['entries'] as $aItem)
            {
                $aEntry = $aItem['entry'];
                
                $aNewEntry = array(
                    'handle' => $aEntry['titel']['_handle'],
                    'title' => $aEntry['titel']['value'],
                );
                        
                if (isset($aCategories[$aEntry['categorie']['item']['_handle']]) == true)
                {
                    $aCategories[$aEntry['categorie']['item']['_handle']]['entries'][] = $aNewEntry;
                }
                else
                {
                    $aCategories[$aEntry['categorie']['item']['_handle']] = array(
                        'title' => $aEntry['categorie']['item']['value'],
                        'entries' => array (
                            $aNewEntry
                        )
                    );
                }
            }
            
            
            // Sort on categorie title
            asort($aCategories);
            
            // Calculations
            $iTotalEntries = count($aResult['entries']);
            
            $fDividedInHalf = $iTotalEntries / 2;
            
            
            // Resulting xml
            $iTotalOutputtedEntries = 0;
            
            foreach ($aCategories as $sCategoryHandle => $aCategoryData)
            {
                $iColumn = ($iTotalOutputtedEntries >= $fDividedInHalf) ? 2 : 1;
                
                $oChildNode = new XMLElement(
                    'category',
                    null, // value
                    array(
                        'handle' => $sCategoryHandle,
                        'title' => $aCategoryData['title'],
                        'column' => $iColumn
                    ) // attributes
                );
                
                if (isset($aCategoryData['entries']) == false
                    || count($aCategoryData['entries']) == 0)
                {
                    continue;    
                }
                
                foreach ($aCategoryData['entries'] as $aEntry)
                {
                    $oEntryNode = new XMLElement(
                        'entry',
                        null,
                        array(
                            'category-handle' => $sCategoryHandle
                        )
                    );
                    
                    $oEntryNode->appendChild(new XMLElement(
                        'title',
                        $aEntry['title'],
                        array(
                            'handle' => $aEntry['handle']
                        )
                    ));
                    
                    $oChildNode->appendChild($oEntryNode);
                    
                    $iTotalOutputtedEntries++;
                }
                
                $result->appendChild($oChildNode);
            }
            
            // return xml result set
            return $result;
        }
        
    }

