<?php

    require_once(EXTENSIONS . '/symql/lib/class.symql.php');

    require_once(TOOLKIT . '/class.datasource.php');
    
    Class PageDetailsData
    {
        public $title = '';
        public $url = '';
        public $metaDataKeywords = '';
        public $metaDataDescription = '';
        public $aBreadcrumbs = array();
        
        public function addBreadcrumb($sUrl, $sTitle)
        {
            array_push($this->aBreadcrumbs, array(
                'url' => $sUrl,
                'title' => $sTitle
            ));
        }
        
        public function reverseBreadcrumbs()
        {
            $this->aBreadcrumbs = array_reverse($this->aBreadcrumbs);
        }
    }

    Class datasourcePage_Details extends Datasource {

        /**
         *
         * name of the root XML element that wraps the data
         * @var string
         */
        public $dsParamROOTELEMENT = 'page-details';

        /**
         *
         * Credits method
         */
        public function about(){
            return array(
                     'name' => 'Page Details',
                     'version' => '1.0',
                     'release-date' => '2012-08-05',
                     'author' => array('name' => 'Jordy Boezaard',
                                       'website' => 'http://www.bitterzoetmedia.nl',
                                       'email' => 'jordy@bitterzoetmedia.nl')
            );
        }

        /**
         *
         * Class constructor
         * @param object $parent
         * @param array $env
         * @param boolean $process_params
         */
		  public function __construct(array $env = null, $process_params=true){
//        public function __construct(&$parent, Array $env = null, $process_params=true){
            //parent::__construct($parent, $env, $process_params);
parent::__construct($env, $process_params);

        }

        /**
         *
         * Method called by Symphony in order to build the
         * @param $param_pool
         * @return XMLElement
         */
        public function grab(array &$param_pool = NULL)
        {
            // Output
            //
            // <page-details>
            //  <title urlencoded="">titel</title>
            //  <url urlencode="">url</url>
            //  <meta-data>
            //      <keywords/>
            //      <description/>
            //  </meta-data>
            // </page-details>
            
            $oPageDetailsData = new PageDetailsData();
            $oPageDetailsData->url = $this->_env['param']['current-url'];
            
            $sTitlePrefix = '';
            
            switch (strtolower($this->_env['param']['current-page']))
            {
                case 'home':
                case 'contact':
                case 'bel-mij-terug':
                case 'offerte-aanvragen':
                case 'direct-reserveren':
                case 'lid-worden':
                case 'inschrijven-contactbijeenkomst':
                case 'bestel-cadeaubon':
                    $this->processMetaDataPage(strtolower($this->_env['param']['current-page']), $oPageDetailsData);
                    
                    break;
                    
                case 'fotoboek':
                    $oPageDetailsData->addBreadcrumb('fotoboek', 'Fotoboek');
                    
                    $this->queryCommon('fotoboeken', null, $this->_env['param']['entry'], $oPageDetailsData);
                    
                    $sTitlePrefix = 'Fotoboek | ';
                    
                    break;
                    
                case 'informatie':
                    $this->queryCommon('paginas', $this->_env['param']['current-page'], $this->_env['param']['entry'], $oPageDetailsData);
                    
                    $sTitlePrefix = 'Informatie | ';
                    
                    break;
                    
                case 'pagina':
                    $this->queryCommon('paginas', $this->_env['param']['current-page'], $this->_env['param']['entry'], $oPageDetailsData);
                    
                    break;
                    
                case 'activiteiten':
                    $oPageDetailsData->addBreadcrumb('activiteiten', 'Activiteiten');
                    
                    $this->processActivityPage($oPageDetailsData);
                    
                    $sTitlePrefix = 'Activiteiten | ';
                    
                    break;
                     
                case 'cursussen':
                    $oPageDetailsData->addBreadcrumb('cursussen', 'Cursussen');
                    
                    $this->processCoursePage($oPageDetailsData);
                    
                    $sTitlePrefix = 'Cursussen | ';
                    
                    break;
                    
                case 'pagina-niet-gevonden':
                    $oPageDetailsData->addBreadcrumb('pagina-niet-gevonden', 'Pagina niet gevonden');
                
                    break;
                    
                default:
                    $oPageDetailsData->addBreadcrumb(strtolower($this->_env['param']['current-page']), ucfirst(strtolower($this->_env['param']['current-page'])));
                    // Do nothing
            }
            
            // prepare output
            $result = new XMLElement($this->dsParamROOTELEMENT);
            
            if (strlen($oPageDetailsData->title) > 0)
            {
                $sTitle = $sTitlePrefix . $oPageDetailsData->title;
            }
            
            $result->appendChild(new XMLElement(
                'title',
                htmlspecialchars($sTitle),
                array(
                    'url-encoded' => urlencode($sTitle)
                )
            ));
            
            $result->appendChild(new XMLElement(
                'url',
                htmlspecialchars($oPageDetailsData->url),
                array(
                    'url-encoded' => urlencode($oPageDetailsData->url)
                )
            ));
            
            
            // Breadcrumbs
            $oBreadcrumbs = new XMLElement(
                'breadcrumbs'
            );
            
            // Walk the stack
            while (count($oPageDetailsData->aBreadcrumbs) > 0)
            {
                $aLastElement = $oPageDetailsData->aBreadcrumbs[count($oPageDetailsData->aBreadcrumbs) - 1];
                
                $sPath = '/';
                
                foreach ($oPageDetailsData->aBreadcrumbs as $aCrumb)
                {
                    $sPath .= $aCrumb['url'] . '/';
                }
                
                $oBreadcrumbs->appendChild(new XMLElement(
                    'breadcrumb',
                    htmlspecialchars($aCrumb['title']),
                    array(
                        'url' => $sPath
                    )
                ));
                
                
                //$sPath = (count($aUrlParts) > 1 || (strtolower($sLastElement) != 'informatie' && strtolower($sLastElement) != 'pagina')) ? '/' . implode('/', $aUrlParts) . '/' : '';
                
                /*$result->appendChild(
                    new XMLElement(
                        'crumb',
                        $this->sanitizeUrlPart($sLastElement), // value
                        array(
                            'path' => $sPath
                        ) // attributes
                    )
                );*/
                
                // Pop last element
                array_pop($oPageDetailsData->aBreadcrumbs);
            }
            
            
            $result->appendChild($oBreadcrumbs);
            
            
            // Meta data
            $oMetaData = new XMLElement(
                'meta-data'
            );
            
            $oMetaData->appendChild(new XMLElement(
                'keywords',
                htmlspecialchars($oPageDetailsData->metaDataKeywords)
            ));
            
            $oMetaData->appendChild(new XMLElement(
                'description',
                htmlspecialchars($oPageDetailsData->metaDataDescription)
            ));
            
            $result->appendChild($oMetaData);
            
            
            // return xml result set
            return $result;
        }
        
        
        private function processMetaDataPage($sPagina, &$oPageDetailsData)
        {   
            // Query
            $query = new SymQLQuery('meta-data');
            $query
                ->select('pagina, keywords, omschrijving')
                ->from('meta-data')
                ->where('pagina', $sPagina)
                ->perPage(1000);
                
            $aResult = SymQL::run($query, SymQL::RETURN_ARRAY);
            
            if (isset($aResult['entries']) === false
                || isset($aResult['entries'][0]) === false
                || isset($aResult['entries'][0]['entry']) === false)
            {
                return;
            }
            
            $aEntry = $aResult['entries'][0]['entry'];
                        
            $oPageDetailsData->metaDataKeywords = $aEntry['keywords']['value'];
            $oPageDetailsData->metaDataDescription = $aEntry['omschrijving']['value'];
        }
        
        
        private function processActivityPage(&$oPageDetailsData)
        {
            // Get db info
            $sCategory = $this->_env['param']['category'];
            $sActivity = $this->_env['param']['activity'];
            
            if ($sCategory != null && strlen($sCategory) > 0
                && $sActivity != null && strlen($sActivity) > 0)
            {
                $this->queryCommon('activiteiten', $sCategory, $sActivity, $oPageDetailsData);
            }
            else if ($sCategory != null && strlen($sCategory) > 0)
            {
                $this->queryCategorie($sCategory, $oPageDetailsData);
            }
            else
            {
                $this->processMetaDataPage('activiteiten', $oPageDetailsData);
            }
        }
        
        private function processCoursePage(&$oPageDetailsData)
        {
            // Get db info
            $sCategory = $this->_env['param']['category'];
            $sCourse = $this->_env['param']['course'];
            
            if ($sCategory != null && strlen($sCategory) > 0
                && $sCourse != null && strlen($sCourse) > 0)
            {
                $this->queryCommon('cursussen', $sCategory, $sCourse, $oPageDetailsData);
            }
            else if ($sCategory != null && strlen($sCategory) > 0)
            {
                $this->queryCategorie($sCategory, $oPageDetailsData);
            }
            else
            {
                $this->processMetaDataPage('cursussen', $oPageDetailsData);
            }
        }
        
        private function queryCommon($sTable, $sCategory, $sTitle, &$oPageDetailsData)
        {
            // Query
            $query = new SymQLQuery('published');
            $query
                ->select('titel, categorie, keywords, omschrijving')
                ->from($sTable)
                ->where('titel', $sTitle);
                
            if ($sCategory != null)
            {
                    $query->where('categorie', $sCategory, SymQL::DS_FILTER_AND);
            }
            
            $query
                ->where('publiceer', 'yes', SymQL::DS_FILTER_AND)
                ->orderby('titel', 'asc')
                ->perPage(1000);

            $aResult = SymQL::run($query, SymQL::RETURN_ARRAY);
            
            if (isset($aResult['entries']) === false
                || isset($aResult['entries'][0]) === false
                || isset($aResult['entries'][0]['entry']) === false)
            {
                return;
            }
            
            $aEntry = $aResult['entries'][0]['entry'];
            
            $oPageDetailsData->title = $aEntry['titel']['value'];
            
            $oPageDetailsData->metaDataKeywords = $aEntry['keywords']['value'];
            $oPageDetailsData->metaDataDescription = $aEntry['omschrijving']['value'];
            
            if ($sCategory != null)
            {
                $oPageDetailsData->addBreadcrumb($aEntry['categorie']['item']['_handle'], $aEntry['categorie']['item']['value']);
            }
            
            $oPageDetailsData->addBreadcrumb($aEntry['titel']['_handle'], $aEntry['titel']['value']);
        }
        
        private function queryCategorie($sCategory, &$oPageDetailsData)
        {   
            // Query
            $query = new SymQLQuery('category');
            $query
                ->select('titel, keywords, omschrijving')
                ->from('categorieen')
                ->where('titel', $sCategory)
                ->perPage(1000);
                
            $aResult = SymQL::run($query, SymQL::RETURN_ARRAY);
            
            if (isset($aResult['entries']) === false
                || isset($aResult['entries'][0]) === false
                || isset($aResult['entries'][0]['entry']) === false)
            {
                return;
            }
            
            $aEntry = $aResult['entries'][0]['entry'];
            
            $oPageDetailsData->title = $aEntry['titel']['value'];
            $oPageDetailsData->metaDataKeywords = $aEntry['keywords']['value'];
            $oPageDetailsData->metaDataDescription = $aEntry['omschrijving']['value'];
            
            $oPageDetailsData->addBreadcrumb($aEntry['titel']['_handle'], $aEntry['titel']['value']);
        }
    }

